#include <iostream>
#include <string>
#include <cstdio>
#include <iomanip>
#include <cmath>
#include <vector>
#include <map>
#include <set>
#include <algorithm>
#include <cstdlib>
#include <queue>
#include <cstring>

using namespace std;

const int MAX_N = 20005;
const int PSZ = 10;
const int PRIMES[PSZ] = {1000000007, 1000000009, 1000003, 8396953, 8396977, 8396981, 8396987, 8397007, 8397017, 8397019};

// bool prime[10000000];
int n, m, dist[MAX_N], cnt[2][MAX_N][PSZ], deg[MAX_N];
vector< int > e[MAX_N], w[MAX_N], idx[MAX_N];
vector< pair< int, int > > ee[MAX_N], re[MAX_N];
priority_queue< pair< int, int > > q;

void countWays(int src, int dst, vector< pair< int, int > > e[], int cnt[][PSZ]) {
    memset(cnt, 0, sizeof(cnt));
    memset(deg, 0, sizeof(deg));

    for (int i = 0; i < PSZ; i++) {
        cnt[src][i] = 1;
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < e[i].size(); j++) {
            deg[e[i][j].first]++;
        }
    }

    queue< int > zero;

    for (int i = 0; i < n; i++) {
        if (!deg[i]) {
            zero.push(i);
        }
    }

    while (!zero.empty()) {
        int u = zero.front();
        zero.pop();

        for (int p = 0; p < PSZ; p++) {
            for (int i = 0; i < e[u].size(); i++) {
                cnt[e[u][i].first][p] = (cnt[e[u][i].first][p] + cnt[u][p]) % PRIMES[p];
            }
        }

        for (int i = 0; i < e[u].size(); i++) {
            deg[e[u][i].first]--;

            if (!deg[e[u][i].first]) {
                zero.push(e[u][i].first);
            }
        }
    }
}

int main() {
	//ios_base::sync_with_stdio(false);
	//freopen(".in", "r", stdin);
	//freopen(".out", "w", stdout);
	
    /*
    memset(prime, true, sizeof(prime));

    prime[0] = prime[1] = false;

    for (int i = 2; i < 10000000; i++) {
        if (!prime[i]) {
            continue;
        }

        if (i > 8000000) {
            cout << i << endl;
        }
        for (long long j = (long long)i * i; j < 10000000; j += i) {
            prime[j] = false;
        }
    }
    */

    scanf("%d %d", &n, &m);

    for (int i = 0; i < m; i++) {
        int u, v, cost;

        scanf("%d %d %d", &u, &v, &cost);

        --u, --v;

        e[u].push_back(v), w[u].push_back(cost), idx[u].push_back(i);
        e[v].push_back(u), w[v].push_back(cost), idx[v].push_back(i);
    }

    memset(dist, -1, sizeof(dist));

    q.push(make_pair(0, 0));

    while (!q.empty()) {
        int u = q.top().second, cost = -q.top().first;

        q.pop();

        if (dist[u] >= 0) {
            continue;
        }

        dist[u] = cost;

        for (int i = 0; i < e[u].size(); i++) {
            int v = e[u][i];

            if (dist[v] < 0) {
                q.push(make_pair(-(cost + w[u][i]), v));
            }
        }
    }

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < e[i].size(); j++) {
            if (dist[e[i][j]] >= 0 && dist[i] >= 0 && dist[e[i][j]] == dist[i] + w[i][j]) {
                ee[i].push_back(make_pair(e[i][j], idx[i][j]));
                re[e[i][j]].push_back(make_pair(i, idx[i][j]));
            }
        }
    }

    countWays(0, n - 1, ee, cnt[0]);
    countWays(n - 1, 0, re, cnt[1]);

    vector< int > ans;

    for (int i = 0; i < n; i++) {
        for (int j = 0; j < ee[i].size(); j++) {
            bool good = true;
            for (int k = 0; k < 10; k++) {
                if (((long long)cnt[0][i][k] * cnt[1][ee[i][j].first][k]) % PRIMES[k] != cnt[0][n - 1][k]) {
                    good = false;
                    break;
                }
            }

            if (good) {
                ans.push_back(ee[i][j].second);
            }
        }
    }

    printf("%d\n", ans.size());

    for (int i = 0; i < ans.size(); i++) {
        printf("%d ", ans[i] + 1);
    }

    printf("\n");

	return 0;
}
